unit DebuggingTipsMainForm;

// Brian Long - Embarcadero MVP
// Email - brian@blong.com
// Web  - http://blong.com
// Blog - http://blog.blong.com

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TMainForm = class(TForm)
    GroupBox1: TGroupBox;
    ODSButton: TButton;
    ODS2Button: TButton;
    AutomationHijackButton: TButton;
    AssertionHijackButton: TButton;
    GroupBox2: TGroupBox;
    UnknownIterationsButton: TButton;
    BreakpointPropertiesButton: TButton;
    ClassNamesButton: TButton;
    InspectorsButton: TButton;
    WatchesButton: TButton;
    ExceptionButton: TButton;
    WhatIfButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ODSButtonClick(Sender: TObject);
    procedure ODS2ButtonClick(Sender: TObject);
    procedure AutomationHijackButtonClick(Sender: TObject);
    procedure AssertionHijackButtonClick(Sender: TObject);
    procedure UnknownIterationsButtonClick(Sender: TObject);
    procedure BreakpointPropertiesButtonClick(Sender: TObject);
    procedure ClassNamesButtonClick(Sender: TObject);
    procedure InspectorsButtonClick(Sender: TObject);
    procedure WhatIfButtonClick(Sender: TObject);
    procedure ExceptionButtonClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure WatchesButtonClick(Sender: TObject);
  private
    { Private declarations }
    FMyList: TList;
    procedure Setup;
    procedure CommonRoutine;
    function GetFoo: Integer;
  public
    { Public declarations }
    property Foo: Integer read GetFoo;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses
  DebugSupport, RTLPatching, StrUtils;

procedure TMainForm.FormClick(Sender: TObject);
begin
  CommonRoutine
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FMyList := TList.Create;
  Setup;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to Pred(FMyList.Count) do
    TObject(FMyList[I]).Free;
  FMyList.Free;
end;

function TMainForm.GetFoo: Integer;
begin
  Color := Random($1000000);
  Result := Tag;
end;

procedure TMainForm.CommonRoutine;
begin
  Caption := TimeToStr(Time);
  Tag := Tag + 1;
end;

procedure TMainForm.ODSButtonClick(Sender: TObject);
begin
{$REGION 'ODS'}
  OutputDebugString('Entering TForm1.Button1Click');
  // body of the interesting routine
  CommonRoutine;
{$IFDEF DEBUG}
  OutputDebugString('You''ll only see me in a debug build!');
{$ENDIF}
  OutputDebugString('Exiting TForm1.Button1Click');
{$ENDREGION}
end;

procedure TMainForm.ODS2ButtonClick(Sender: TObject);
begin
{$REGION 'Custom logger'}
  DebugMsg('Entering TForm1.Button2Click at %s', [TimeToStr(Time)]);
  //body of the interesting routine
  CommonRoutine;
  DebugMsg('Exiting TForm1.Button2Click', True);
{$ENDREGION}
end;

procedure TMainForm.AutomationHijackButtonClick(Sender: TObject);
begin
{$REGION 'Automation-based logging Take 1'}
  Msg.Say('Entering the key code area');
{$ENDREGION}
{$REGION 'Automation-based logging Take 2'}
  Msg.Say('Entering', Name := 'TMainForm.AutomationHijackButtonClick', DateTime := Now);
  //body of the interesting routine
  CommonRoutine;
  Msg.Say('Exiting', Name := 'TMainForm.AutomationHijackButtonClick', DateTime := Now, Pi := 3.14159265358979);
{$ENDREGION}
end;

procedure TMainForm.AssertionHijackButtonClick(Sender: TObject);
begin
{$REGION 'Assertion-based logging'}
  Assert(False, 'TMainForm.AssertionHijackButtonClick');
  //body of the interesting routine
  CommonRoutine;
  Assert(False, 'TMainForm.AssertionHijackButtonClick');
{$ENDREGION}
end;

procedure TMainForm.WatchesButtonClick(Sender: TObject);
{$REGION 'Watches'}
var
  S: string;
begin
  // To see Watch side effect issues, add a watch
  // on both Color and Foo and step through the code
  S := 'Hello world';
  Caption := S;
  ShowMessage('Boo!');
  Color := Random($1000000);
  Caption := ReverseString(S);
  S := Caption;
{$ENDREGION}
end;

procedure TMainForm.UnknownIterationsButtonClick(Sender: TObject);
{$REGION 'Unknown iterations'}
var
  I: Integer;
const
  SafeIterations = 950;
begin
  // Use a colossally high pass count to work out which iteration gives the failure
  for I := 1 to 1000 do
  begin
    CommonRoutine;
    // Look out: flashing colours!!!!
    //Color := Random($1000000);
    if I = SafeIterations then
    begin
      PByte(nil)^ := 5;
    end;
  end;
{$ENDREGION}
end;

procedure TMainForm.BreakpointPropertiesButtonClick(Sender: TObject);
begin
{$REGION 'Breakpoint properties'}
  CommonRoutine;
  Color := Random($1000000);
  // Use a breakpoint group to break here only under criteria of another
  // execution path having been followed.
  // Don't forget the startup state of the breakpoint group.
  if Sender is TComponent then
  begin
    TComponent(Sender).Tag := TComponent(Sender).Tag + 1;
    Caption := Format('%s has been clicked %d times', [TComponent(Sender).Name, TComponent(Sender).Tag]);
  end;
{$ENDREGION}
end;

procedure TMainForm.WhatIfButtonClick(Sender: TObject);
{$REGION '"What if?" scenarios'}
var
  S: string;
begin
  S := 'Hello world';
  Caption := S;
  ShowMessage('Boo!');
  Color := Random($1000000);

  // Just because...:
  // if we are in a debug session and targeting Win32, then hardcode a breakpoint
{$IFDEF WIN32}
  if ByteBool(DebugHook) then asm int 3 end;
{$ENDIF}
  Caption := ReverseString(Caption);

  // Just because...:
  // if we are in a debug session and targeting Win32/Win64, then hardcode a breakpoint
{$IFDEF MSWINDOWS}
  if ByteBool(DebugHook) then DebugBreak;
{$ENDIF}
{$ENDREGION}
end;

type
  TFoo = class
    &Message: string;
    Number: Integer;
    procedure VirtualMethod1; virtual;
  end;

  TBar = class(TFoo)
    Data: string;
    procedure VirtualMethod1; override;
    procedure VirtualMethod2; virtual;
  end;

procedure TMainForm.Setup;
var
  Foo: TFoo;
  Bar: TBar;
begin
  Foo := TFoo.Create;
  Foo.Message := 'First';
  Foo.Number := 1;
  FMyList.Add(Foo);
  Bar := TBar.Create;
  Bar.Message := 'Second';
  Bar.Number := 2;
  Bar.Data := 'Data';
  FMyList.Add(Bar);
  Foo := TFoo.Create;
  Foo.Message := 'Third';
  Foo.Number := 3;
  FMyList.Add(Foo);
  CommonRoutine;
end;

procedure TMainForm.ClassNamesButtonClick(Sender: TObject);
begin
  CommonRoutine;
  ShowMessage('What type of item is the second in the list?');
  // Breakpoint on the end; below
  // Put a watch on FMyList[1] to get the object reference address value
  // Copy that watch value into the clipboard
  // Add another watch on either this
  // (Delphi XE4 (?) or earlier, or recent versions):
  //    TObject(x).ClassName
  // or this (for Delphi XE5 and maybe XE6, which were broken):
  //    TObject(PPointer(x)^).ClassName
  // pasting in the value in the clipboard in place of x and
  // remembering to ensure side effects and functions calls are allowed
  // This gives the class name string, which in this case will be 'TBar'
  // Now you can modify the first watch with a cast: TBar(FMyList[1])
end;

procedure TMainForm.InspectorsButtonClick(Sender: TObject);
begin
  CommonRoutine;
  ShowMessage('Let''s have a look at the list');
  // Breakpoint on the end; below
  // Click on this unit's FMyList field and press Alt+F5 to invoke a debug inspector
  // Right-click on the TList's FList field and choose Descend (Ctrl+D) to inspect it
  // Select the second pointer value and press Ctrl+D to inspect it
  // Right-click and choose Typecast (Ctrl+T) to change inspected type from Pointer to TBar
end;

procedure TMainForm.ExceptionButtonClick(Sender: TObject);
begin
{$REGION 'AV'}
  PByte(nil)^ := 5;
{$ENDREGION}
end;

{ TFoo }

procedure TFoo.VirtualMethod1;
begin
  ShowMessage('TFoo.VirtualMethod1');
end;

{ TBar }

procedure TBar.VirtualMethod1;
begin
  ShowMessage('TBar.VirtualMethod1');
end;

procedure TBar.VirtualMethod2;
begin
  ShowMessage('TBar.VirtualMethod2');
end;

end.
